/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;

import intrinsic.mx.controls.*;

public class ProgressBar extends Control {

public ProgressBar (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
	style |= SWT.NO_FOCUS;
	return checkBits (style, SWT.HORIZONTAL, SWT.VERTICAL, 0, 0, 0, 0);
}

void createHandle () {
	intrinsic.mx.controls.ProgressBar widget = new intrinsic.mx.controls.ProgressBar();
	widget.indeterminate = (style & SWT.INDETERMINATE) != 0;
	widget.mode = ProgressBarMode.MANUAL;
	widget.maximum = 100;
	widget.label = "";
	object = widget;
}

public int getMaximum () {
	checkWidget ();
	intrinsic.mx.controls.ProgressBar widget = (intrinsic.mx.controls.ProgressBar)object;
	return (int)widget.maximum;
}

public int getMinimum () {
	checkWidget ();
	intrinsic.mx.controls.ProgressBar widget = (intrinsic.mx.controls.ProgressBar)object;
	return (int)widget.minimum;
}

public int getSelection () {
	checkWidget ();
	intrinsic.mx.controls.ProgressBar widget = (intrinsic.mx.controls.ProgressBar)object;
	return (int)widget.value;
}

public int getState () {
	checkWidget ();
	return SWT.NORMAL;
}

public void setMaximum (int value) {
	checkWidget();
	intrinsic.mx.controls.ProgressBar widget = (intrinsic.mx.controls.ProgressBar)object;
	widget.maximum = value;
}

public void setMinimum (int value) {
	checkWidget();
	intrinsic.mx.controls.ProgressBar widget = (intrinsic.mx.controls.ProgressBar)object;
	widget.minimum = value;
}

public void setSelection (int value) {
	checkWidget();
	intrinsic.mx.controls.ProgressBar widget = (intrinsic.mx.controls.ProgressBar)object;
	widget.setProgress(value, widget.maximum);
}

public void setState (int state) {
	checkWidget ();
	switch (state) {
		case SWT.NORMAL:
			break;
		case SWT.ERROR:
			break;
		case SWT.PAUSED:
			break;
	}
}

}
